/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css;

import com.aptana.css.core.parsing.CSSTokenType;
import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.css.internal.text.rules.CSSHexColorRule;
import com.aptana.editor.css.internal.text.rules.CSSIdentifierRule;
import com.aptana.editor.css.internal.text.rules.CSSImportantRule;
import com.aptana.editor.css.internal.text.rules.CSSNumberRule;
import com.aptana.editor.css.internal.text.rules.EqualOperatorWordDetector;
import com.aptana.editor.css.internal.text.rules.IdentifierWithPrefixDetector;
import com.aptana.editor.css.internal.text.rules.KeywordIdentifierDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CSSCodeScannerRuleBased
extends BufferedRuleBasedScanner {
    public static final String KEYWORD_MEDIA = "@media";
    public static final String[] DEPRECATED_COLORS = new String[]{"aliceblue", "antiquewhite", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkgrey", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkslategrey", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dimgrey", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "gainsboro", "ghostwhite", "gold", "goldenrod", "greenyellow", "grey", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightslategrey", "lightsteelblue", "lightyellow", "limegreen", "linen", "magenta", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "oldlace", "olivedrab", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "skyblue", "slateblue", "slategray", "slategrey", "snow", "springgreen", "steelblue", "tan", "thistle", "tomato", "turquoise", "violet", "wheat", "whitesmoke", "yellowgreen"};
    public static final String[] STANDARD_COLORS = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "orange", "purple", "red", "silver", "teal", "white", "yellow"};
    public static final String[] MEDIA = new String[]{"all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "tty", "tv"};
    public static final String[] HTML_TAGS = new String[]{"a", "abbr", "acronym", "address", "area", "b", "base", "big", "blockquote", "body", "br", "button", "caption", "cite", "code", "col", "colgroup", "dd", "del", "details", "dfn", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "form", "frame", "frameset", "head", "hr", "html", "h1", "h2", "h3", "h4", "h5", "h6", "i", "iframe", "img", "input", "ins", "kbd", "label", "legend", "li", "link", "map", "mark", "menu", "meta", "noframes", "noscript", "object", "ol", "optgroup", "option", "p", "param", "pre", "q", "samp", "script", "select", "small", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "tt", "ul", "var", "header", "nav", "section", "article", "footer", "aside", "audio", "video", "canvas", "hgroup"};
    public static final String[] FUNCTIONS = new String[]{"rgba", "rgb", "url", "attr", "counters", "counter", "linear-gradient"};
    public static final String[] PROPERTY_NAMES = new String[]{"alignment-adjust", "alignment-baseline", "azimuth", "background-attachment", "background-clip", "background-color", "background-image", "background-origin", "background-position-x", "background-position-y", "background-position", "background-quantity", "background-repeat", "background-size", "background-spacing", "background", "behavior", "border-bottom-color", "border-bottom-left-radius", "border-bottom-right-radius", "border-bottom-style", "border-bottom-width", "border-bottom", "border-collapse", "border-color", "border-image-source", "border-image-slice", "border-image-width", "border-image-outset", "border-image-repeat", "border-image", "border-left-color", "border-left-style", "border-left-width", "border-left", "border-radius", "border-right-color", "border-right-style", "border-right-width", "border-right", "border-spacing", "border-style", "border-top-color", "border-top-left-radius", "border-top-right-radius", "border-top-style", "border-top-width", "border-top", "border-width", "border", "bottom", "box-decoration-break", "box-shadow", "box-sizing", "caption-side", "clear", "clip", "column-count", "column-gap", "column-rule", "column-width", "color", "content", "counter-increment", "counter-reset", "cue-after", "cue-before", "cue", "cursor", "direction", "display", "elevation", "empty-cells", "filter", "fit", "fit-position", "float", "font-family", "font-size-adjust", "font-size", "font-stretch", "font-style", "font-variant", "font-weight", "font", "height", "left", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "margin-bottom", "margin-left", "margin-right", "margin-top", "marker-offset", "margin", "marks", "max-aspect-ratio", "max-color-index", "max-color", "max-device-aspect-ratio", "max-device-height", "max-device-width", "max-height", "max-width", "min-aspect-ratio", "min-color-index", "min-color", "min-device-aspect-ratio", "min-device-height", "min-device-width", "min-height", "min-monochrome", "min-width", "monochrome", "-moz-border-radius", "offx", "offy", "opacity", "orientation", "orphans", "outline-color", "outline-offset", "outline-style", "outline-width", "outline", "overflow-x", "overflow-y", "overflow", "padding-bottom", "padding-left", "padding-right", "padding-top", "padding", "page-break-after", "page-break-before", "page-break-inside", "page", "pause-after", "pause-before", "pause", "pitch-range", "pitch", "play-during", "position", "quotes", "resize", "richness", "right", "size", "speak-header", "speak-numeral", "speak-punctuation", "speech-rate", "speak", "src", "stress", "table-layout", "text-align", "text-decoration", "text-indent", "text-overflow", "text-shadow", "text-transform", "top", "transform", "transition", "unicode-bidi", "user-select", "vertical-align", "visibility", "voice-family", "volume", "weight", "white-space", "widows", "width", "word-break", "word-spacing", "word-wrap", "z-index", "zoom"};
    public static final String[] PROPERTY_VALUES = new String[]{"absolute", "all-scroll", "always", "armenian", "auto", "baseline", "below", "bidi-override", "blink", "block", "bold", "bolder", "border-box", "both", "bottom", "break-all", "break-word", "capitalize", "center", "char", "circle", "cjk-ideographic", "col-resize", "collapse", "content-box", "crosshair", "dashed", "decimal-leading-zero", "decimal", "default", "disabled", "disc", "distribute-all-lines", "distribute-letter", "distribute-space", "distribute", "dotted", "double", "e-resize", "ease-in-out", "ease-in", "ease-out", "ease", "ellipsis", "fixed", "georgian", "groove", "hand", "hebrew", "help", "hidden", "hiragana-iroha", "hiragana", "horizontal", "ideograph-alpha", "ideograph-numeric", "ideograph-parenthesis", "ideograph-space", "inactive", "inherit", "inline-block", "inline", "inset", "inside", "inter-ideograph", "inter-word", "italic", "justify", "katakana-iroha", "katakana", "keep-all", "landscape", "larger", "large", "left", "lighter", "line-edge", "line-through", "linear", "line", "list-item", "loose", "lower-alpha", "lower-greek", "lower-latin", "lower-roman", "lowercase", "lr-tb", "ltr", "medium", "middle", "move", "n-resize", "ne-resize", "newspaper", "no-drop", "no-repeat", "nw-resize", "none", "normal", "not-allowed", "nowrap", "oblique", "outset", "outside", "overline", "pointer", "portrait", "progress", "relative", "repeat-x", "repeat-y", "repeat", "right", "ridge", "row-resize", "rtl", "s-resize", "scroll", "se-resize", "separate", "small-caps", "smaller", "solid", "square", "static", "strict", "super", "sw-resize", "table-footer-group", "table-header-group", "tb-rl", "text-bottom", "text-top", "text", "thick", "thin", "top", "transparent", "underline", "upper-alpha", "upper-latin", "upper-roman", "uppercase", "vertical-ideographic", "vertical-text", "vertical", "visible", "w-resize", "wait", "whitespace", "xx-large", "xx-small", "x-small", "x-large", "zero"};
    public static final String[] FONT_NAMES = new String[]{"arial", "clean", "century", "comic", "courier", "garamond", "geneva", "georgia", "helvetica", "impact", "lucida", "monaco", "symbol", "system", "tahoma", "times", "trebuchet", "utopia", "verdana", "webdings", "sans-serif", "serif", "monospace"};
    public static final Pattern CURLY_MEDIA_PATTERN = Pattern.compile("([{}]|@media)");
    private int fCurlyState;
    private boolean fInMedia;
    protected boolean fInPropertyValue;
    protected boolean fInSelector;
    public static final VendorPropertyWordRule VENDOR_WORD_RULE = new VendorPropertyWordRule(new IdentifierWithPrefixDetector('-'), (IToken)new Token((Object)CSSTokenType.PROPERTY), true);

    public CSSCodeScannerRuleBased() {
        List<IRule> rules = this.createRules();
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private void addWordsToRule(WordRule wordRule, String[] words, CSSTokenType tokenType) {
        IToken token = this.createToken(tokenType);
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            wordRule.addWord(word, token);
            ++n2;
        }
    }

    protected WordRule createAtWordsRule() {
        WordRule atRule = new WordRule((IWordDetector)new IdentifierWithPrefixDetector('@'), this.createToken(CSSTokenType.AT_RULE));
        atRule.addWord("@import", this.createToken(CSSTokenType.IMPORT));
        atRule.addWord("@page", this.createToken(CSSTokenType.PAGE));
        atRule.addWord(KEYWORD_MEDIA, this.createToken(CSSTokenType.MEDIA_KEYWORD));
        atRule.addWord("@charset", this.createToken(CSSTokenType.CHARSET));
        atRule.addWord("@font-face", this.createToken(CSSTokenType.FONTFACE));
        atRule.addWord("@namespace", this.createToken(CSSTokenType.NAMESPACE));
        return atRule;
    }

    protected CharacterMapRule createPunctuatorsRule() {
        CharacterMapRule punctuatorsRule = new CharacterMapRule();
        punctuatorsRule.add(':', this.createToken(CSSTokenType.COLON));
        punctuatorsRule.add(';', this.createToken(CSSTokenType.SEMICOLON));
        punctuatorsRule.add('{', this.createToken(CSSTokenType.LCURLY));
        punctuatorsRule.add('}', this.createToken(CSSTokenType.RCURLY));
        punctuatorsRule.add('(', this.createToken(CSSTokenType.LPAREN));
        punctuatorsRule.add(')', this.createToken(CSSTokenType.RPAREN));
        punctuatorsRule.add('%', this.createToken(CSSTokenType.PERCENTAGE));
        punctuatorsRule.add('[', this.createToken(CSSTokenType.LBRACKET));
        punctuatorsRule.add(']', this.createToken(CSSTokenType.RBRACKET));
        punctuatorsRule.add(',', this.createToken(CSSTokenType.COMMA));
        punctuatorsRule.add('+', this.createToken(CSSTokenType.PLUS));
        punctuatorsRule.add('*', this.createToken(CSSTokenType.STAR));
        punctuatorsRule.add('>', this.createToken(CSSTokenType.GREATER));
        punctuatorsRule.add('/', this.createToken(CSSTokenType.SLASH));
        punctuatorsRule.add('=', this.createToken(CSSTokenType.EQUAL));
        punctuatorsRule.add('-', this.createToken(CSSTokenType.MINUS));
        return punctuatorsRule;
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new KeywordIdentifierDetector(), Token.UNDEFINED);
        this.addWordsToRule(wordRule, this.getPropertyNames(), CSSTokenType.PROPERTY);
        this.addWordsToRule(wordRule, PROPERTY_VALUES, CSSTokenType.VALUE);
        this.addWordsToRule(wordRule, HTML_TAGS, CSSTokenType.ELEMENT);
        this.addWordsToRule(wordRule, MEDIA, CSSTokenType.MEDIA);
        this.addWordsToRule(wordRule, STANDARD_COLORS, CSSTokenType.COLOR);
        this.addWordsToRule(wordRule, DEPRECATED_COLORS, CSSTokenType.DEPRECATED_COLOR);
        rules.add((IRule)wordRule);
        rules.add((IRule)new WordRule((IWordDetector)new IdentifierWithPrefixDetector('.'), this.createToken(CSSTokenType.CLASS)));
        rules.add((IRule)this.createAtWordsRule());
        rules.add((IRule)new CSSImportantRule(this.createToken(CSSTokenType.IMPORTANT)));
        wordRule = new WordRule((IWordDetector)new KeywordIdentifierDetector(), Token.UNDEFINED, true);
        this.addWordsToRule(wordRule, FONT_NAMES, CSSTokenType.FONT);
        rules.add((IRule)wordRule);
        rules.add((IRule)this.createVendorPropertyRules());
        WordRule punctuatorRule2 = new WordRule((IWordDetector)new EqualOperatorWordDetector(), Token.UNDEFINED);
        punctuatorRule2.addWord("~=", this.createToken(CSSTokenType.INCLUDES));
        punctuatorRule2.addWord("|=", this.createToken(CSSTokenType.DASHMATCH));
        punctuatorRule2.addWord("^=", this.createToken(CSSTokenType.BEGINS_WITH));
        punctuatorRule2.addWord("$=", this.createToken(CSSTokenType.ENDS_WITH));
        rules.add((IRule)punctuatorRule2);
        rules.add((IRule)this.createPunctuatorsRule());
        rules.add((IRule)new CSSHexColorRule(this.createToken(CSSTokenType.RGB)));
        rules.add((IRule)new WordRule((IWordDetector)new IdentifierWithPrefixDetector('#'), this.createToken(CSSTokenType.ID)));
        rules.addAll(this.createScannerSpecificRules());
        rules.add((IRule)new CSSNumberRule(this.createToken(CSSTokenType.NUMBER)));
        rules.add((IRule)new CSSIdentifierRule(this.createToken(CSSTokenType.IDENTIFIER)));
        return rules;
    }

    protected Collection<? extends IRule> createScannerSpecificRules() {
        ArrayList<WordRule> rules = new ArrayList<WordRule>();
        WordRule wordRule = new WordRule((IWordDetector)new KeywordIdentifierDetector(), Token.UNDEFINED);
        wordRule.addWord("em", this.createToken(CSSTokenType.EMS));
        wordRule.addWord("ex", this.createToken(CSSTokenType.EXS));
        wordRule.addWord("px", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("cm", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("mm", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("in", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("pt", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("pc", this.createToken(CSSTokenType.LENGTH));
        wordRule.addWord("deg", this.createToken(CSSTokenType.ANGLE));
        wordRule.addWord("rad", this.createToken(CSSTokenType.ANGLE));
        wordRule.addWord("grad", this.createToken(CSSTokenType.ANGLE));
        wordRule.addWord("ms", this.createToken(CSSTokenType.TIME));
        wordRule.addWord("s", this.createToken(CSSTokenType.TIME));
        wordRule.addWord("hz", this.createToken(CSSTokenType.FREQUENCY));
        wordRule.addWord("khz", this.createToken(CSSTokenType.FREQUENCY));
        wordRule.addWord("Hz", this.createToken(CSSTokenType.FREQUENCY));
        wordRule.addWord("kHz", this.createToken(CSSTokenType.FREQUENCY));
        this.addWordsToRule(wordRule, FUNCTIONS, CSSTokenType.FUNCTION);
        rules.add(wordRule);
        return rules;
    }

    protected IToken createToken(CSSTokenType type) {
        return new Token((Object)type);
    }

    protected IToken createToken(String scope) {
        return new Token((Object)scope);
    }

    private ExtendedWordRule createVendorPropertyRules() {
        return VENDOR_WORD_RULE;
    }

    protected String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        if (token.isEOF()) {
            return token;
        }
        Object tokenData = token.getData();
        if (CSSTokenType.MEDIA_KEYWORD == tokenData) {
            this.fInMedia = true;
            this.fCurlyState = 0;
        } else if (CSSTokenType.LCURLY == tokenData) {
            if (this.insideMedia() && this.fCurlyState == 0) {
                token = this.createToken(CSSTokenType.LCURLY_MEDIA);
            }
            ++this.fCurlyState;
        } else if (CSSTokenType.RCURLY == tokenData) {
            this.fInPropertyValue = false;
        } else if (CSSTokenType.PROPERTY == tokenData) {
            this.fInSelector = false;
        } else if (CSSTokenType.COLON == tokenData) {
            this.fInPropertyValue = true;
        } else if (CSSTokenType.CLASS == tokenData || CSSTokenType.ID == tokenData || CSSTokenType.STAR == tokenData || CSSTokenType.ELEMENT == tokenData) {
            this.fInSelector = true;
        }
        StringBuilder builder = new StringBuilder();
        if (this.insideMedia()) {
            builder.append(CSSTokenType.META_MEDIA.getScope()).append(' ');
        }
        if (this.insideRule()) {
            builder.append(CSSTokenType.META_RULE.getScope()).append(' ');
        } else if (this.fInSelector) {
            builder.append(CSSTokenType.META_SELECTOR.getScope()).append(' ');
        }
        if (this.insidePropertyValue()) {
            builder.append(CSSTokenType.META_PROPERTY_VALUE.getScope()).append(' ');
        }
        if (!this.fInPropertyValue && CSSTokenType.VALUE == tokenData) {
            token = this.createToken(CSSTokenType.PROPERTY);
        } else if (CSSTokenType.LCURLY == tokenData) {
            this.fInSelector = false;
        } else if (CSSTokenType.RCURLY == tokenData) {
            --this.fCurlyState;
            if (this.fCurlyState <= 0 && this.insideMedia()) {
                token = this.createToken(CSSTokenType.RCURLY_MEDIA);
                this.fInMedia = false;
            }
        } else if (CSSTokenType.SEMICOLON == tokenData) {
            this.fInPropertyValue = false;
        }
        if (token.isOther()) {
            tokenData = token.getData();
            if (tokenData != null) {
                if (tokenData instanceof CSSTokenType) {
                    builder.append(((CSSTokenType)tokenData).getScope());
                } else if (tokenData instanceof String) {
                    builder.append((String)tokenData);
                }
            } else if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
        } else if (token.isWhitespace()) {
            if (builder.length() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            } else {
                return token;
            }
        }
        return this.createToken(builder.toString());
    }

    private boolean insidePropertyValue() {
        return this.fInPropertyValue;
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fCurlyState = 0;
        this.fInMedia = false;
        this.fInPropertyValue = false;
        this.fInSelector = false;
        if (offset > 0) {
            String previous = null;
            try {
                ITypedRegion[] partitions;
                ITypedRegion[] iTypedRegionArray = partitions = this.fDocument.computePartitioning(0, offset);
                int n = partitions.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypedRegion region = iTypedRegionArray[n2];
                    if (!("__css_multiline_comment".equals(region.getType()) || "__css_string_double".equals(region.getType()) || "__css_string_single".equals(region.getType()))) {
                        previous = this.fDocument.get(region.getOffset(), region.getLength());
                        Matcher m = CURLY_MEDIA_PATTERN.matcher(previous);
                        while (m.find()) {
                            String found = m.group();
                            if ("{".equals(found)) {
                                ++this.fCurlyState;
                                continue;
                            }
                            if ("}".equals(found)) {
                                --this.fCurlyState;
                                if (this.fCurlyState > 0 || !this.insideMedia()) continue;
                                this.fInMedia = false;
                                continue;
                            }
                            if (!KEYWORD_MEDIA.equals(found)) continue;
                            this.fInMedia = true;
                            this.fCurlyState = 0;
                        }
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private boolean insideRule() {
        if (this.insideMedia()) {
            return this.fCurlyState > 1;
        }
        return this.fCurlyState > 0;
    }

    private boolean insideMedia() {
        return this.fInMedia;
    }

    static final class VendorPropertyWordRule
    extends ExtendedWordRule {
        private VendorPropertyWordRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            super(detector, defaultToken, ignoreCase);
        }

        public boolean wordOK(String word, ICharacterScanner scanner) {
            return word.startsWith("-moz-") || word.startsWith("-webkit-") || word.startsWith("-ms-") || word.startsWith("-o-") || word.startsWith("-atsc-") || word.startsWith("-khtml-") || word.startsWith("-wap-");
        }
    }
}

